
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                 Includes                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// (c) 2017 Miroslav Nemecek, Panda38@seznam.cz, panda38.sweb.cz

// Compile as "Release x64" version, using Microsoft Visual Studio 2005 C++

///////////////////////////////////////////////////////////////////////////////
// base types

typedef char				s8;
typedef short				s16;
typedef long				s32;
typedef long long			s64;

typedef unsigned char		u8;
typedef unsigned short		u16;
typedef unsigned long		u32;
typedef unsigned long long	u64;

/*
typedef signed __int8		s8;
typedef signed __int16		s16;
typedef signed __int32		s32;
typedef signed __int64		s64;

typedef unsigned __int8		u8;
typedef unsigned __int16	u16;
typedef unsigned __int32	u32;
typedef unsigned __int64	u64;
*/

///////////////////////////////////////////////////////////////////////////////
// compilation switches
// _DEBUG	... debug version
// WIN64 ... 64-bit mode

//#define _MT		// uncomment this to use multithread
#undef _MT			// uncomment this to NOT use multithread

#define OPTIMISE	// use cached values and more optimisation


#ifdef OPTIMISE
#ifdef WIN64

#define X86			// use assembler x86 (64-bit)

#endif // WIN64
#endif // OPTIMISE

#pragma warning ( disable: 4100)		// warning - unreferenced parameter
#pragma warning ( disable: 4996)		// warning - unsafe function
#pragma warning ( disable: 4201)		// warning - nameless struct/union
#pragma warning ( disable: 4127)		// warning - condition is constant

///////////////////////////////////////////////////////////////////////////////
// system includes

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#include <time.h>
#include <Windows.h> // required only for time measures

///////////////////////////////////////////////////////////////////////////////
// constants

#define PI 3.14159265358979324

#define	B0 (1<<0)
#define	B1 (1<<1)
#define	B2 (1<<2)
#define	B3 (1<<3)
#define	B4 (1<<4)
#define	B5 (1<<5)
#define	B6 (1<<6)
#define	B7 (1<<7)
#define	B8 (1<<8)
#define	B9 (1<<9)
#define	B10 (1<<10)
#define	B11 (1<<11)
#define	B12 (1<<12)
#define	B13 (1<<13)
#define	B14 (1<<14)
#define	B15 (1<<15)

#define B16 (1<<16)
#define B17 (1<<17)
#define B18 (1<<18)
#define	B19 (1<<19)
#define B20 (1<<20)
#define B21 (1<<21)
#define B22 (1<<22)
#define B23 (1<<23)
#define B24 (1<<24)
#define B25 (1<<25)
#define B26 (1<<26)
#define B27 (1<<27)
#define B28 (1<<28)
#define B29 (1<<29)
#define B30 (1<<30)
#define B31 (1UL<<31)

#define	BIGINT	0x40000000

///////////////////////////////////////////////////////////////////////////////
// inplace "new" operator
//		example:	new (&m_List[inx]) cText;
//					m_List[i].~cText()

inline void* operator new (size_t size, void* p)
{
	size;
	return p;
}

inline void operator delete (void* adr, void* p)
{
	adr; p;
	return;
}

///////////////////////////////////////////////////////////////////////////////
// program includes

#include "util/cpu.h"			// CPU control
#include "util/lock.h"			// multithread lock
#include "util/text.h"			// text string
#include "dblint/test.h"		// double integer test
#include "math/bignum.h"		// big numbers
#include "main/parse.h"			// parser
#include "main/main.h"			// main module
